<?php
class AuthController {
    public function loginView() {
        if(is_logged_in()){
            header('Location: ' . APP_URL . '/admin');
            exit;
        }
        include_once __ROOT__ . '/admin/views/login_view.php';
    }

    public function handleLogin() {
        $username = $_POST['username'];
        $password = $_POST['password'];

        $db = get_db_connection();
        $stmt = $db->prepare("SELECT * FROM admins WHERE username = ?");
        $stmt->bind_param('s', $username);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($user = $result->fetch_assoc()) {
            if (password_verify($password, $user['password'])) {
                $_SESSION['admin_id'] = $user['id'];
                $_SESSION['admin_username'] = $user['username'];
                header('Location: ' . APP_URL . '/admin');
                exit;
            }
        }
        
        $_SESSION['flash_message'] = 'Invalid username or password.';
        header('Location: ' . APP_URL . '/admin/login');
        exit;
    }

    public function logout() {
        session_destroy();
        header('Location: ' . APP_URL . '/admin/login');
        exit;
    }
}